% Nise, N.S. 
% Control Systems Engineering, 7th ed. 
% John Wiley & Sons, Hoboken, NJ, 07030
%
% Control Systems Engineering Toolbox Version 7.0 
% Copyright  2015 by John Wiley & Sons, Inc.
%
% (ch10p6): We can use MATLAB to plot Nichols charts using nichols(G), 
% where G(s) = numg/deng and G is an LTI transfer-function object. The 
% Nichols grid can be added using the ngrid command after the nichols(G) 
% command. Information about the plots obtained with nichols(G) can be 
% found by left-clicking the mouse on the curve. You can find the curve's 
% label, as well as the coordinates of the point on which you clicked 
% and the frequency. Right clicking away from a curve brings up a menu 
% if the icons on the menu bar are deselected. From this menu you 
% can select (1) system responses to be displayed and (2) characteristics, 
% such as peak response. When selected, a dot appears on the curve at 
% the appropriate point. Let your mouse rest on the point to read the value 
% of the characteristic. You also may  select (3) choice for grid on or off, 
% (4) returning to full view after zooming, and (5) properties, such as 
% labels, limits, units, style, and characteristics. Let us make a Nichols 
% chart of G(s) = 1/[s(s+1)(s+2)].

'(ch10p6)'                          % Display label.
clf                                 % Clear graph.
numg=1;                             % Define numerator of G(s).
deng=poly([0 -1 -2]);               % Define denominator of G(s).
'G(s)'                              % Display label.
G=tf(numg,deng)                     % Create and display G(s).
nichols(G)                          % Make a Nichols plot.
ngrid                               % Add Nichols grid.
